import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/data/controller/home/home_controller.dart';

import '../../../../core/utils/dimensions.dart';
import '../../../../core/utils/my_color.dart';
import '../../../../core/utils/my_strings.dart';
import '../../../../core/utils/style.dart';
import '../../../../data/controller/send_money/send_money_controller.dart';
import '../../../components/divider/custom_divider.dart';

class SummarySection extends StatelessWidget {

  final SendMoneyController controller;

  const SummarySection({
    super.key,
    required this.controller
  });

  @override
  Widget build(BuildContext context) {
    return Container(
        padding: const EdgeInsets.symmetric(horizontal: 16,vertical: 24),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(Dimensions.space8),
          border: Border.all(),
        ),
        child: Column(
          children: [
            Row(
              children: [
                Text(MyStrings.sendingAmount.tr,style: mediumLarge.copyWith(color: MyColor.bodyTextColor)),
                const Spacer(),
                Text("${controller.getSendingAmount()} ${controller.getCurrency()}",style: mediumLarge),
              ],
            ),
            const CustomDivider(),
            Row(
              children: [
                Text(MyStrings.totalCharge.tr,style: mediumLarge.copyWith(color: MyColor.bodyTextColor)),
                const Spacer(),
                Text("${Get.find<HomeController>().getCharge()} ${controller.getCurrency()}",style: mediumLarge),
              ],
            ),
            const CustomDivider(),
            Row(
              children: [
                Text(MyStrings.finalAmount.tr,style: mediumLarge.copyWith(color: MyColor.bodyTextColor)),
                const Spacer(),
                Text("${controller.getFinalAmount()} ${controller.getCurrency()}",style: mediumLarge),
              ],
            ),
            const CustomDivider(),
            Row(
              children: [
                Text('${MyStrings.payableIn.tr} ${controller.sendMoneyRepo.apiClient.getCurrencyOrUsername(isCurrency: true)}',style: mediumLarge.copyWith(color: MyColor.bodyTextColor)),
                const Spacer(),
                Text("${controller.getAmountInUsd()} ${controller.sendMoneyRepo.apiClient.getCurrencyOrUsername(isCurrency: true)}",style: mediumLarge.copyWith(color: MyColor.primaryColor)),
              ],
            ),
          ],
        ),
      );
  }
}